#include <allegro.h>
#include "vars.h"
#include "draw.h"
#include "sprites.h"
#include "fonts.h"

extern char *key_names[];

void draw(void) {
   prepare_to_draw();

   switch (game_state) {
      case PLAYING_THE_GAME:
         draw_game();
         break;
      case ASKING_PLAYER_NAME:
         draw_name_input();
         break;
      default:
         break;
   }

   //on s'occupe de la capture d'cran
   if (key[KEY_F12]) 
      save_bmp("Out.bmp", buffer, NULL);

   buffer_onto_screen();

   return;
}

void prepare_to_draw(void) {
   if (draw_method == TRIPLE_BUFFER) {
      if (current_page == 0) {
         buffer = page2; 
         current_page = 1;
      }
      else if (current_page == 1) {
         buffer = page3; 
         current_page = 2; 
      }
      else {
         buffer = page1; 
         current_page = 0;
      }
      //clear(buffer); pas vraiment la peine car on ecrase ce qu'il y a dessus!
   }
   else if (draw_method == PAGE_FLIPPING) {
      if (current_page == 2) {
         buffer = page1; 
         current_page = 1;
      }
      else {
         buffer = page2; 
         current_page = 2; 
      }
   }
   if (draw_method != DOUBLE_BUFFER)
      acquire_bitmap(buffer);
   return;
}

void buffer_onto_screen(void) {
   if (draw_method != DOUBLE_BUFFER)
      release_bitmap(buffer);

   if (draw_method == TRIPLE_BUFFER) {
		/* Il faut être sur que le dernier flip a bien eu lieu */
      do {
      } while (poll_scroll());

      /* On demande à ce que le buffer soit affiché */
      request_video_bitmap(buffer);
   }
   else if (draw_method == PAGE_FLIPPING){
      show_video_bitmap(buffer);
   }
	else if (draw_method == DOUBLE_BUFFER) {
	   if (ENABLE_VSYNC == TRUE)
	      vsync();
      blit(buffer, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
   }
   
   return;
}

void draw_game(void) {
   int i;
   
   clear_bitmap(buffer);

   //Dessine les toiles. EN PREMIER CAR DERRIERE LE PLAN DU JEU
   for (i = 0; i < stars.nb_stars; ++i)
      putpixel(buffer, stars.star[i].x/stars.star[i].z + SCREEN_W/2, stars.star[i].y/stars.star[i].z + SCREEN_H/2, makecol(255/(stars.star[i].z/4+1),255/(stars.star[i].z/4+1),255/(stars.star[i].z/6+1)));

   //on affiche les balles!
   for (i = 0; i < nb_max_balls; ++i) {
      if (ball[i]->EXIST == TRUE) {
         draw_sprite(buffer, ball[i]->bitmap, ball[i]->position.x - ball[i]->bitmap->w/2, ball[i]->position.y - ball[i]->bitmap->h/2);
      }
   }
   
   //on affiche les raquettes
   for (i = 0; i < nb_max_players; ++i) {
      draw_sprite(buffer, player[i]->racket->main_bitmap, player[i]->racket->position.x - player[i]->racket->main_bitmap->w/2, player[i]->racket->position.y - player[i]->racket->main_bitmap->h/2);

      //le +1 est naturel  cette fin de ligne (voir comment marche les sprites ;) )
      draw_sprite(buffer, player[i]->racket->top_bitmap, player[i]->racket->position.x - player[i]->racket->top_bitmap->w/2, player[i]->racket->position.y - player[i]->racket->circle_centre_interval - player[i]->racket->top_bitmap->h+1);      
      draw_sprite(buffer, player[i]->racket->bottom_bitmap, player[i]->racket->position.x - player[i]->racket->bottom_bitmap->w/2, player[i]->racket->position.y + player[i]->racket->circle_centre_interval);      
   }

   //on affiche les tincelles!
   for (i = 0; i < NB_MAX_SPARKS; ++i) {
      if (spark[i].EXIST == TRUE)  
         putpixel(buffer, spark[i].pos.x, spark[i].pos.y, spark[i].color);
   }


   //on affiche le logo qui symbolise le niveau:
   draw_sprite(buffer, game.cur_level->logo_bitmap, SCREEN_W/2 - game.cur_level->logo_bitmap->w/2, 0);

   
   text_mode(-1);
   
   textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/5,5,makecol(150,255,255), "Score : %ld", current_score);
   textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, 4*SCREEN_W/5,5,makecol(150,255,255), "FPS : %d", fps);
   
   //On regarde si une aprtie VIENT de se terminer, on laisse pendant 3 secondes
   if (game_info.last_score != NOT_DEFINED && current_score <= SHOW_SCORE_TIME) {
      switch (game_type) {
         case DUEL_2AI:
            textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, SCREEN_H/2-75,makecol(150,255,255), "Game Over");
            textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2 - text_height(data_fonts[FONT02_PCX].dat), makecol(150,255,255), "Score : %ld", game_info.last_score);
            textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2+20, makecol(150,200,255), "%ld - %ld", game_info.nb_left_wins, game_info.nb_right_wins);

            if (player[0]->pos == LEFT) 
               textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2+40, makecol(200,200,255), "%ld - %ld", player[0]->score, player[1]->score);
            else 
               textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2+40, makecol(200,200,255), "%ld - %ld", player[1]->score, player[0]->score);

            
            if (game_info.winning_side == LEFT) {
               textprintf(buffer, data_fonts[FONT02_PCX].dat, 25, SCREEN_H/2,makecol(150,200,255), "You won!");   
               textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W-25-text_length(data_fonts[FONT02_PCX].dat, "You lost!"), SCREEN_H/2,makecol(150,255,255), "You lost!");   
            }
            else if (game_info.winning_side == RIGHT) {
               textprintf(buffer, data_fonts[FONT02_PCX].dat, 25, SCREEN_H/2,makecol(150,255,255), "You lost!");   
               textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W-25-text_length(data_fonts[FONT02_PCX].dat, "You won!"), SCREEN_H/2,makecol(150,200,255), "You won!");   
            }
            
            break;
         case DUEL:
            //si on a perdu, on affiche le high_score
            if (game_info.new_hiscore_pos == -1) {
               textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, SCREEN_H/2-75,makecol(150,255,255), "Game Over");
               textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2-25,makecol(150,255,255), "You scored : %ld", game_info.last_score);

               for (i = 0; i < SIZE_HIGH_SCORE_TABLE; ++i) {
                  textprintf_right(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2-10, SCREEN_H/2+(20*i), makecol((255/((float)SIZE_HIGH_SCORE_TABLE+1))*(SIZE_HIGH_SCORE_TABLE-i+1),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5)), "%s", game.cur_level->high_score.high_score_entry[i].name);
                  textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2+10, SCREEN_H/2+(20*i), makecol((255/((float)SIZE_HIGH_SCORE_TABLE+1))*(SIZE_HIGH_SCORE_TABLE-i+1),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5)), "%ld", game.cur_level->high_score.high_score_entry[i].score);
               }
            }
            break;
         case DUEL_2P:
            //si on a perdu, on affiche le high_score
            textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, SCREEN_H/2-75,makecol(150,255,255), "Game Over");
            textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2-25,makecol(150,255,255), "You scored : %ld", game_info.last_score);
            textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2+20, makecol(150,200,255), "%ld - %ld", game_info.nb_left_wins, game_info.nb_right_wins);

            if (player[0]->pos == LEFT) 
               textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2+40, makecol(200,200,255), "%ld - %ld", player[0]->score, player[1]->score);
            else 
               textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2+40, makecol(200,200,255), "%ld - %ld", player[1]->score, player[0]->score);



            if (game_info.winning_side == LEFT) {
               textprintf(buffer, data_fonts[FONT02_PCX].dat, 25, SCREEN_H/2,makecol(150,200,255), "You won!");   
               textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W-25-text_length(data_fonts[FONT02_PCX].dat, "You lost!"), SCREEN_H/2,makecol(150,255,255), "You lost!");   
            }
            else if (game_info.winning_side == RIGHT) {
               textprintf(buffer, data_fonts[FONT02_PCX].dat, 25, SCREEN_H/2,makecol(150,255,255), "You lost!");   
               textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W-25-text_length(data_fonts[FONT02_PCX].dat, "You won!"), SCREEN_H/2,makecol(150,200,255), "You won!");   
            }
            
            break;

         case DUEL_2P_VS_AI:

            //si on a perdu, on affiche le high_score
            textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, SCREEN_H/2-75,makecol(150,255,255), "Game Over");
            textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2-25,makecol(150,255,255), "You scored : %ld", game_info.last_score);

            if (game_info.winning_side == LEFT) {
               textprintf(buffer, data_fonts[FONT02_PCX].dat, 25, SCREEN_H/2,makecol(150,200,255), "You won!");   
               textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W-25-text_length(data_fonts[FONT02_PCX].dat, "You lost!"), SCREEN_H/2,makecol(150,255,255), "You lost!");   
            }
            else if (game_info.winning_side == RIGHT) {
               textprintf(buffer, data_fonts[FONT02_PCX].dat, 25, SCREEN_H/2,makecol(150,255,255), "You lost!");   
               textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W-25-text_length(data_fonts[FONT02_PCX].dat, "You won!"), SCREEN_H/2,makecol(150,200,255), "You won!");   
            }
            
            break;
         
         default:
            break;
      }      
   }
   

   return;
}

void draw_menu(TPONG_MENU* menu) {

   prepare_to_draw();
   
   switch (game_state) {
      case IN_MENU:
         draw_main_menu(menu);
         break;
      case IN_OPTION_MENU:
         draw_option_menu(menu);
         break;
      case IN_MODE_SELECTOR_MENU:
         draw_mode_selector_menu(menu);
         break;
      default:
         break;
   }

   //on s'occupe de la capture d'cran
   if (key[KEY_F12]) 
      save_bmp("Out.bmp", buffer, NULL);
   
   buffer_onto_screen();
      
   return;
}

void draw_main_menu(TPONG_MENU* menu) {
   int i;   
   clear_bitmap(buffer);//clear_bitmap nouveau nom de fonction!

   //LE TITRE !
   text_mode(-1);   
   textprintf_centre(buffer, font, SCREEN_W/2, 1, makecol(150,255,255), "Tpong " TPONG_VERSION " by Emeric Poupon (ITM)");
   textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, SCREEN_H/2-100,makecol(150,255,255), "TPong");
   textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2-50,makecol(150,200,255), "Why not make the AI unbeatable?");
   
   for (i = 0; i < menu->nb_elements; ++i) {
      text_mode(-1);
      if (menu->cur_selection == i) {
         //le commentaire en bas...
         textout_centre(buffer, font, menu->element[i].des, SCREEN_W/2, SCREEN_H - text_height(font)-1, makecol(200,200,255));         
         text_mode(makecol(95,95,95));
      }
      switch (menu->element[i].name_pos) {
         case RIGHT:
            textout_right(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));   
            break;
         case LEFT:
            textout(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));            
            break;
         case CENTRE:
            textout_centre(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));            
            break;
         default:
            break;
      }
   }
  
   return;
}

void draw_option_menu(TPONG_MENU* menu) {
   int i;
   clear_bitmap(buffer);//clear_bitmap nouveau nom de fonction!
   //LE TITRE !
   text_mode(-1);
   textprintf_centre(buffer, font, SCREEN_W/2, 1, makecol(150,255,255), "Tpong " TPONG_VERSION " by Emeric Poupon (ITM)");
   textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, SCREEN_H/2-120,makecol(150,255,255), "Options");
   //textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2,makecol(150,200,255), "Redefine keyboard");
   
   switch (menu->cur_selection) {
      case OPTION_MENU_PL:
      case OPTION_MENU_PL1:      
         rotate_sprite(buffer, data_sprite[RACKET_BLUE_BMP].dat, SCREEN_W/4.0*3, menu->element[menu->cur_selection].pos.y - ((BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat))->h/2 + ((BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat))->w, itofix(64));         
         rotate_sprite(buffer, data_sprite[RACKET_BLUE_T_BMP].dat, SCREEN_W/4.0*3 + 1 + ((BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat))->h/2, menu->element[menu->cur_selection].pos.y - ((BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat))->h/2 + ((BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat))->w, itofix(64));
			rotate_sprite(buffer, data_sprite[RACKET_BLUE_B_BMP].dat, SCREEN_W/4.0*3 - 1 - ((BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat))->h/2, menu->element[menu->cur_selection].pos.y - ((BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat))->h/2 + ((BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat))->w, itofix(64));         
         break;
      case OPTION_MENU_PL2:         
         rotate_sprite(buffer, data_sprite[RACKET_RED_BMP].dat, SCREEN_W/4.0*3, menu->element[menu->cur_selection].pos.y - ((BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat))->h/2 + ((BITMAP*)(data_sprite[RACKET_RED_BMP].dat))->w, itofix(64));
         rotate_sprite(buffer, data_sprite[RACKET_RED_T_BMP].dat, SCREEN_W/4.0*3 + 1 + ((BITMAP*)(data_sprite[RACKET_RED_BMP].dat))->h/2, menu->element[menu->cur_selection].pos.y - ((BITMAP*)(data_sprite[RACKET_RED_T_BMP].dat))->h/2 + ((BITMAP*)(data_sprite[RACKET_RED_T_BMP].dat))->w, itofix(64));
			rotate_sprite(buffer, data_sprite[RACKET_RED_B_BMP].dat, SCREEN_W/4.0*3 - 1 - ((BITMAP*)(data_sprite[RACKET_RED_BMP].dat))->h/2, menu->element[menu->cur_selection].pos.y - ((BITMAP*)(data_sprite[RACKET_RED_T_BMP].dat))->h/2 + ((BITMAP*)(data_sprite[RACKET_RED_T_BMP].dat))->w, itofix(64));         
         
         break;
      default:
         break;
   }      
   
   for (i = 0; i < menu->nb_elements; ++i) {
      text_mode(-1);
      if (menu->cur_selection == i) {
         //le commentaire en bas...
         textout_centre(buffer, font, menu->element[i].des, SCREEN_W/2, SCREEN_H - text_height(font)-1, makecol(200,200,255));         
         text_mode(makecol(95,95,95));
      }
      switch (menu->element[i].name_pos) {
         case RIGHT:
            textout_right(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));   
            break;
         case LEFT:
            textout(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));            
            break;
         case CENTRE:
            textout_centre(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));            
            break;
         default:
            break;
      }
      //ici, on rajoute en face de l'option les touches courantes:
      text_mode(-1);      
      switch (i) {
         case OPTION_MENU_DEFINE_GAME_MODE:
            textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2 + 20, menu->element[i].pos.y, makecol(200,200,255), "%s", game.cur_level->name);         
            break;
         case OPTION_MENU_PL:
            textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2 + 20, menu->element[i].pos.y - 10, makecol(200,200,255), "%s", key_names[single_player.key_up]);
            textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2 + 20, menu->element[i].pos.y + 10, makecol(200,200,255), "%s", key_names[single_player.key_down]);
            break;
         case OPTION_MENU_PL1:
            textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2 + 20, menu->element[i].pos.y - 10, makecol(200,200,255), "%s", key_names[left_player.key_up]);
            textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2 + 20, menu->element[i].pos.y + 10, makecol(200,200,255), "%s", key_names[left_player.key_down]);
            break;
         case OPTION_MENU_PL2:
            textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2 + 20, menu->element[i].pos.y - 10, makecol(200,200,255), "%s", key_names[right_player.key_up]);
            textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2 + 20, menu->element[i].pos.y + 10, makecol(200,200,255), "%s", key_names[right_player.key_down]);
            break;
         default:
            break;
      }
   }
   
   
   return;
}
   
void draw_mode_selector_menu(TPONG_MENU* menu) {
   int i;
   clear_bitmap(buffer);//clear_bitmap nouveau nom de fonction!
   //LE TITRE !
   text_mode(-1);
   textprintf_centre(buffer, font, SCREEN_W/2, 1, makecol(150,255,255), "Tpong " TPONG_VERSION " by Emeric Poupon (ITM)");
   textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, SCREEN_H/2-100,makecol(150,255,255), "Game selector");
   textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/2-50,makecol(150,200,255), "Choose your game");
   
   if (menu->cur_selection < MODE_SELECTOR_MENU_RETURN) {
      draw_sprite(buffer, data_sprite[NUCLEAR1_BMP + menu->cur_selection].dat, menu->element[menu->cur_selection].pos.x + text_length(data_fonts[FONT02_PCX].dat, menu->element[menu->cur_selection].name)/2 + ((BITMAP*)(data_sprite[NUCLEAR1_BMP + menu->cur_selection].dat))->w/2, menu->element[menu->cur_selection].pos.y - ( ((BITMAP*)(data_sprite[NUCLEAR1_BMP + menu->cur_selection].dat))->h - text_height(data_fonts[FONT02_PCX].dat))/2 );
      draw_sprite(buffer, data_sprite[NUCLEAR1_BMP + menu->cur_selection].dat, menu->element[menu->cur_selection].pos.x - text_length(data_fonts[FONT02_PCX].dat, menu->element[menu->cur_selection].name)/2 - 3.0/2*((BITMAP*)(data_sprite[NUCLEAR1_BMP + menu->cur_selection].dat))->w, menu->element[menu->cur_selection].pos.y - ( ((BITMAP*)(data_sprite[NUCLEAR1_BMP + menu->cur_selection].dat))->h - text_height(data_fonts[FONT02_PCX].dat))/2 );
   }


   for (i = 0; i < menu->nb_elements; ++i) {
      text_mode(-1);
      if (menu->cur_selection == i) {
         //le commentaire en bas...
         textout_centre(buffer, font, menu->element[i].des, SCREEN_W/2, SCREEN_H - text_height(font)-1, makecol(200,200,255));         
         text_mode(makecol(95,95,95));
         //Les symboles  gauche et  droite :)
      }
      switch (menu->element[i].name_pos) {
         case RIGHT:
            textout_right(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));   
            break;
         case LEFT:
            textout(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));            
            break;
         case CENTRE:
            textout_centre(buffer, data_fonts[FONT02_PCX].dat, menu->element[i].name, menu->element[i].pos.x, menu->element[i].pos.y, makecol(64,170,255));            
            break;
         default:
            break;
      }
   }
   
   return;
}

void draw_name_input(void) {
   int i;

   clear_bitmap(buffer);

   textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, 10, makecol(1,255,255), "Congratulations!");
   textprintf_centre(buffer, data_fonts[FONT01_PCX].dat, SCREEN_W/2, 40, makecol(1,255,255), "New Hiscore!");
   textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, 90, makecol(150,255,255), "Enter your name");
   
   textout_right(buffer, data_fonts[FONT02_PCX].dat, name, SCREEN_W/2-10, SCREEN_H/2+(20*game_info.new_hiscore_pos), makecol(1,255,255));

   for (i = 0; i < SIZE_HIGH_SCORE_TABLE; ++i) {
      
      textprintf_right(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2-10, SCREEN_H/2+(20*i), makecol((255/((float)SIZE_HIGH_SCORE_TABLE+1))*(SIZE_HIGH_SCORE_TABLE-i+1),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5)), "%s", game.cur_level->high_score.high_score_entry[i].name);
      textprintf(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2+10, SCREEN_H/2+(20*i), makecol((255/((float)SIZE_HIGH_SCORE_TABLE+1))*(SIZE_HIGH_SCORE_TABLE-i+1),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5),(255/((float)SIZE_HIGH_SCORE_TABLE+5))*(SIZE_HIGH_SCORE_TABLE-i+5)), "%ld", game.cur_level->high_score.high_score_entry[i].score);

   }
   
   return;
}

